#include <p30fxxxx.h>
#include <incap.h>

/* These devices support Input Capture 3 thru Input Capture 6 */
#if defined(__dsPIC30F6010__) || defined(__dsPIC30F5011__) || defined(__dsPIC30F6011__) || \
    defined(__dsPIC30F6012__) || defined(__dsPIC30F5013__) || defined(__dsPIC30F6013__) || \
    defined(__dsPIC30F6014__)

/********************************************************************
*    Function Name:  ConfigIntCapture4                              *
*    Description:    Set the Enable Interrupts and Interrupt        *
*                    Priorites  to the Interrupt Control and        *
*                    Interrupt Priority Register respectively       *
*    Parameters:     unsigned int config                            *
*    Return Value:   None                                           *
********************************************************************/

void ConfigIntCapture4(unsigned int config)
{
    IFS1bits.IC4IF = 0;                   /* Clear IF bit */
    IPC7bits.IC4IP = (config &0x0007);    /* assigning Interrupt Priority
                                             to IPC Register             */
    IEC1bits.IC4IE = (config &0x0008) >> 3;/* assiging Interrupt Enable/
                                              Disable Register           */
}

#endif
